% ALPHA ENGINE DEFINITION
% Generated 16-May-2018 14:58:29

% SUGGESTED CITATION:
% 2016 Honda 1.5L L15B7 Engine Tier 3 Fuel - ALPHA Map Package. Version 2018-05. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2018.


% Constructor
engine = class_REVS_engine();
engine.name =  '2016 Honda 1.5L L15B7 Engine Tier 3 Fuel'; 
engine.source_filename = mfilename;engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  1.496; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  10.6; 
engine.stroke_mm =  89.4; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	    0.00000000000000000	;     104.71975511965977	;     131.00441365469436	;     157.23434767253738	;     168.06441765895070	;     181.04276745406747	;     200.88739690454730	;     262.44047703171123	;     366.76972233284550	;     418.58509116597367	;     471.57250525835008	;     523.87485495270528	;     628.31853071795865	;     659.73445725385659	;     691.15038378975453		]; 
engine.full_throttle_torque_Nm = [	    0.00000000000000000	;     119.19600000000000	;     130.21899999999999	;     194.31380645161295	;     209.89418181818195	;     232.94635135135110	;     237.76416666666674	;     238.69902439024389	;     237.52807142857134	;     226.60136363636374	;     233.50800000000027	;     227.87090909090912	;     206.90142601946394	;     177.34407944525483	;    0.00000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	    0.00000000000000000	;     130.99917766693841	;     208.52753628594030	;     314.15664536179594	;     366.53652080068741	;     418.70361056372087	;     471.17073139629036	;     575.92490203577381	;     691.15038378975453		]; 
engine.naturally_aspirated_torque_Nm = [	     127.33847571469407	;     108.87801047992515	;     109.19868726747083	;     100.05606978192583	;     97.258335153831268	;     99.928464192148937	;     121.16447935790303	;     129.45762931118892	;     134.77425836621973		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	    0.00000000000000000	;     104.71975511965977	;     261.79938779914943	;     366.51914291880917	;     523.49405584317913	;     691.15038378975453		]; 
engine.closed_throttle_torque_Nm = [	    -12.691535133783448	;    -15.551000000000002	;    -18.120999999999999	;    -20.736000000000001	;    -26.986000000000001	;    -31.564003250812707		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	    0.00000000000000000	;     37.830011536977096	;     75.660023073954193	;     104.80411270017285	;     130.99917766693841	;     157.10011383637757	;     167.82018464562555	;     183.45587485525772	;     208.52753628594030	;     235.89050958687719	;     261.82668434536834	;     314.15664536179594	;     366.53652080068741	;     418.70361056372087	;     471.17073139629036	;     523.53127335358909	;     575.92490203577381	;     628.31853071795865	;     659.73445725385659	;     691.15038378975453		]; 
engine.fuel_map_torque_Nm = [	    -33.142203413353343	;    -18.866636363636360	;    -5.3460000000000001	;     6.4334166666666670	;     19.543839999999999	;     32.465750000000000	;     38.476999999999997	;     42.272416666666665	;     52.236349999999995	;     67.424958333333336	;     79.669678571428562	;     92.617714285714285	;     102.08277272727273	;     115.37239285714284	;     126.01338888888890	;     140.31056250000000	;     156.03149999999999	;     166.63869053643725	;     175.27407569571790	;     187.45401343701394	;     197.89453708693793	;     202.53767773293401	;     209.74185901139430	;     225.94422044213707	;     236.92672252494629	;     250.63397560975611		]; 
engine.fuel_map_gps = [
 0.0017137831008889421	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	4.1231746479507546e-05	;
  0.042538768439488464	  0.018793677096110298	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	  0.015809715010408010	  0.041391379156555511	   0.10666322882201425	   0.20552920755441487	   0.33998352013187855	   0.39471426028346090	   0.42207207323669904	   0.43997706588208396	   0.45896307274797699	;
  0.070949158612790039	  0.079281887685583058	  0.086523163587817503	  0.084538049058327638	  0.093175384598349800	   0.11228401857422649	   0.12157347103739921	   0.13597159363327305	   0.16081441961588006	   0.19116055701138893	   0.22409082106696335	   0.29294791206735488	   0.35006270548006790	   0.44373733018157169	   0.58940277092998261	   0.83323524980836705	   0.84605122750062667	   0.86927745971044401	   0.88931533799513540	   0.91087697722160899	;
  0.083345304157493194	   0.11229952309219859	   0.13715745658429893	   0.14829082418359266	   0.18073654697350355	   0.22160666723189859	   0.23893086764394339	   0.26416677897506069	   0.30166220548040135	   0.34478194549143620	   0.38870376110411764	   0.49275097619870573	   0.58930722986734041	   0.70480577716322312	   0.83353864293257485	   0.98960175460352195	    1.1598416838224543	    1.2458611899071725	    1.2857676088427603	    1.3238115153221701	;
  0.081455271014835198	   0.13254280262695289	   0.18308883066268278	   0.22534413402336206	   0.27946198669277150	   0.33398517827807656	   0.35724252084097408	   0.39163349954978843	   0.44850203155990220	   0.50441002425782477	   0.55517994813574711	   0.68153562769629994	   0.83927589265093760	   0.98595246922111113	    1.1657796238735318	    1.3473394878683105	    1.5270077681473071	    1.6650486384113155	    1.7359240751306562	    1.8037869363990235	;
  0.070053390075874383	   0.15358986235347932	   0.23877295492791820	   0.30783981335593530	   0.37384786323722508	   0.44428569651494931	   0.47430708732347487	   0.51875239451673316	   0.59108277299703571	   0.67147164569540430	   0.74918871979116120	   0.92350847760382404	    1.0909045820680823	    1.2751967723331441	    1.5015946532562618	    1.7320394047252825	    1.9291701994583232	    2.1070099912076361	    2.2083455785561359	    2.3082279271882653	;
  0.064518387158751730	   0.16438581398132721	   0.26549405610251015	   0.34503395720649177	   0.41706271986603149	   0.49241833304731386	   0.52473793740898245	   0.57297355135542272	   0.65426862062208146	   0.74719588219635125	   0.83878056720329874	    1.0243966247795708	    1.1998864779869005	    1.4008772951254806	    1.6541606584647266	    1.9065387374831058	    2.1229810714736623	    2.3237384003735984	    2.4406686732516691	    2.5567248898023345	;
  0.061072760452769395	   0.17131545645538029	   0.28226047543825417	   0.36803897747187686	   0.44400980332541884	   0.52221640593253615	   0.55593241377902569	   0.60649897026152999	   0.69356068633057044	   0.79383714695760998	   0.89311680405682026	    1.0866288308572507	    1.2672996827983578	    1.4790826616918245	    1.7499177192349225	    2.0147874186345116	    2.2463517689869636	    2.4626991573184576	    2.5899197878959637	    2.7165928357750371	;
  0.052375441504354199	   0.18986848899760067	   0.32543980557137953	   0.42597652056044288	   0.51225327826353495	   0.59817410688603712	   0.63586871725920213	   0.69276777857214733	   0.79276118906794235	   0.90938405573669134	    1.0219797104602326	    1.2420689695326412	    1.4390107905456337	    1.6823686712376809	    1.9978748997153362	    2.2955089029517413	    2.5755369883509838	    2.8391777577749076	    2.9964963159452429	    3.1539724663205781	;
  0.040694760421458899	   0.21885612760600198	   0.39225744985506178	   0.51950029237100548	   0.63028022197137701	   0.73271518470637997	   0.77713519758541372	   0.84326255276573359	   0.95319598399785477	    1.0859684112321748	    1.2151347851986760	    1.4743786208509613	    1.7508611779096144	    2.0291125780742925	    2.3940278102446482	    2.7583064920348970	    3.1115392292044204	    3.4831265576053569	    3.7127834024184581	    3.9443929118127046	;
  0.038351823299372763	   0.24924776963834652	   0.45893780213827523	   0.61837139352301018	   0.75891161435014665	   0.87233822463884880	   0.92211072145750428	   0.99648283851729802	    1.1195511436073404	    1.2645419422258957	    1.4077612991036355	    1.6917292711728995	    1.9971352307435828	    2.3241780165848698	    2.7223359301244074	    3.1252921812004488	    3.5762139826702577	    4.0931118022656978	    4.4187922213802500	    4.7483603172084186	;
  0.056597031593006310	   0.29437659528705240	   0.53446880102938077	   0.71968509251150814	   0.88311851614782144	    1.0248166678216186	    1.0825218800995755	    1.1666622712866910	    1.3004672742929619	    1.4571764463639485	    1.6144011138992347	    1.9480631755465039	    2.2804111228280770	    2.6598891724857490	    3.0646599552271958	    3.5132163146933943	    4.1143672849221202	    4.8445843357338534	    5.3061270740355910	    5.7728166110295573	;
  0.092358077334034103	   0.34045215567284270	   0.59247563646598889	   0.79222999106284808	   0.97293080196104742	    1.1232174145471434	    1.1855537937661245	    1.2765670966908620	    1.4232242303643570	    1.5957993793768557	    1.7648239769781082	    2.1159984297285233	    2.4874676185753319	    2.9088733539247293	    3.3205537012133384	    3.8099038891875914	    4.5614007211904104	    5.4759551024769886	    6.0491941547516106	    6.6272774639067507	;
   0.18278297370363278	   0.43593994778490963	   0.69101286965747222	   0.89930282645484783	    1.1160368993808041	    1.2782443157587653	    1.3444401488243527	    1.4416878309906409	    1.6051116069821223	    1.8004913432986633	    1.9952561902518153	    2.3699498264447079	    2.7746026131539789	    3.2326706255272670	    3.6747911789610881	    4.2905268116767514	    5.3117251642811398	    6.5012381231748666	    7.2338782652998157	    7.9694678894352515	;
   0.29353091257069724	   0.55192386662455906	   0.82453176697815178	    1.0521494016073145	    1.2593035258970016	    1.4066364721544276	    1.4748343970725228	    1.5788285952855872	    1.7558576285591223	    1.9587554920808943	    2.1557087577901437	    2.5759140852050657	    3.0014247952991200	    3.4702170955139353	    3.9760345487589848	    4.8526576603091947	    6.0767890543319751	    7.4568180325275701	    8.2976489233669017	    9.1395459915349004	;
   0.49752942288757090	   0.74747355468023224	    1.0039245232372898	    1.2069277770895808	    1.3917246552943598	    1.5794954345663630	    1.6635402960727219	    1.7892389792439884	    1.9915777339883409	    2.2065497445336821	    2.4070225657945938	    2.8340135200268368	    3.3601722474490474	    3.8412627173578540	    4.5152778031887637	    5.8105812060766340	    7.3427537351349965	    8.9194105303167781	    9.8616926877087057	    10.802112992425680	;
   0.74556564332174202	   0.98411782195741293	    1.2218466093540510	    1.4120469219366578	    1.5987305499570692	    1.8123070767215432	    1.9075576450114600	    2.0511124354521271	    2.2887456875498193	    2.5297010687198220	    2.7515065836045896	    3.1797639873514334	    3.6647127727265207	    4.2640349880071176	    5.4281227723834293	    7.2662811866575687	    9.0264255141037548	    10.688918087928046	    11.675166739909622	    12.660191995565008	;
   0.87222560447855313	    1.1413198628575196	    1.4064839643813634	    1.6085132673906677	    1.7929357925308338	    1.9923268243705738	    2.0844815073482708	    2.2239516874896204	    2.4601172357461643	    2.7068717074174389	    2.9425956685564092	    3.4583470223248582	    4.1535842372461671	    5.3168596308740996	    6.1005096389813387	    8.3695469985167090	    10.168745743223285	    11.860811831948043	    12.867829914867357	    13.874096589781262	;
   0.94269713302550229	    1.2543755167752708	    1.5608001803400859	    1.7910506857859170	    1.9946528426702572	    2.1947259497680531	    2.2758187602571063	    2.3966601846451154	    2.6012991717745249	    2.8466257887893058	    3.1112268229812789	    3.8057691140061358	    4.6490305899130826	    6.2821393634942497	    6.8102976408298472	    9.1641358971278102	    11.041235305278658	    12.780946734258229	    13.807448503808242	    14.830713772675807	;
   0.97203170477431189	    1.3665024451333352	    1.7540178728990892	    2.0399631168444876	    2.2829911939289711	    2.5022650951983398	    2.5821815078385368	    2.6788786435556218	    2.8199219003954736	    3.0802064379800127	    3.4348451022449065	    4.5506246979217817	    5.4457684732776848	    6.6366988575646166	    8.4720432928363660	    10.203302231203050	    12.175707464743374	    14.006347751002359	    15.062724442262155	    16.110092995979407	;
   0.91057292646250831	    1.3810511269593866	    1.8432780170129544	    2.1791771275490879	    2.4534495185382936	    2.6838760162681337	    2.7661032343970424	    2.8801426329658422	    3.0740992886678415	    3.4132101170770790	    3.8580859544611048	    5.2218817143628309	    6.5080878764888128	    7.5602801017803847	    10.213567602397779	    11.450535322074405	    13.145573575730458	    14.977873389847424	    16.050295382368709	    17.120370046240499	;
   0.86512624773010127	    1.3673567472286554	    1.8610435265124019	    2.2210372140018779	    2.5178691821252048	    2.7743302315187806	    2.8700007518351627	    3.0039972544275471	    3.2340262442441481	    3.6237302298828289	    4.1080086583851783	    5.4585561613830249	    6.7526289940082531	    7.9244449933669987	    10.591133818032809	    11.943397552835227	    13.564925282716898	    15.388451803152105	    16.471648228918060	    17.554472399078847	;
   0.77769459045993428	    1.3268211143658422	    1.8675885247181383	    2.2672172050746622	    2.6084863724405731	    2.9266590753467874	    3.0508671424692437	    3.2252410370468048	    3.5228192770991673	    3.9999677094161101	    4.5871385484417440	    5.8382462857630228	    7.2214266703558243	    8.4929831341453994	    11.016894057029708	    12.616372901326462	    14.196004262290490	    16.007035578199037	    17.110338534531298	    18.214783675254822	;
   0.45016579442841276	    1.0896166648600414	    1.7318843464656988	    2.2371635679920843	    2.7069599694736066	    3.1973885328584983	    3.4034307294781430	    3.7058464128049802	    4.1947145582456793	    4.8038557612804169	    5.4625221894166209	    7.0420823965630310	    8.5191605374669468	    9.9230543368585398	    11.910983583790614	    13.502698990900436	    15.394122791116740	    17.309383780333370	    18.456439159774114	    19.602613835528398	;
   0.16861845720775323	   0.87579276746372781	    1.5911648279974338	    2.1568019813769732	    2.6797259252076833	    3.2196487156137796	    3.4476660905259386	    3.7866986449550200	    4.3620318960000688	    5.0567681141220113	    5.7098111493961099	    7.4880316114834757	    9.4939240786369421	    11.071873762934684	    12.837991135247540	    14.398866181093435	    16.243271087061480	    18.168663189447429	    19.327569195017123	    20.486488957919178	;
   0.00000000000000000	   0.60085635856096786	    1.3919103610947932	    2.0293290975598604	    2.6209829221770260	    3.2361225259476747	    3.4962591717368299	    3.8820386486425122	    4.5294211264620765	    5.3016880358937533	    6.1068158229936653	    8.1106309680537141	    10.388865374658925	    12.351909809916178	    14.026113446040334	    15.632485660635915	    17.365111629655654	    19.242873276470576	    20.396935857128739	    21.557195981767006	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('FTAG 25206');

% Idle Speed
engine.idle_speed_radps = class_REVS_dynamic_lookup;
engine.idle_speed_radps.axis_1.signal =  'veh_spd_mps'; 
engine.idle_speed_radps.axis_1.breakpoints = [	    0.00000000000000000	    10.000000000000000		]; 
engine.idle_speed_radps.table = [	     65.973445725385659	;     65.973445725385659		]; 

% Pedal Calibration
engine.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;

% Calibration Adjustment Factors
% -- None -- 
